/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.events.*;

public class TableColumn extends Item {
	Table parent;
	Object jsColumn;

public TableColumn (Table parent, int style) {
	this (parent, style, -1);
}

public TableColumn (Table parent, int style, int index) {
	super (parent, style, index);
//FIXME TEMP "underscore" fix, until the Item constructor is "losing" the index in the constructor
	this._createWidget(this.display, parent, style, index);
}

public void addControlListener (ControlListener listener) {
}

public void addSelectionListener (SelectionListener listener) {
}

protected void checkSubclass () {
}

//FIXME TEMP "underscore" fix, until the Item constructor is "losing" the index in the constructor 
void _createWidget(Display display, Widget parent, int style, int index) {
	this.display = display;
	this.parent = (Table) parent;
	int newIndex = index;
	if (index==-1) { newIndex = this.parent.getColumnCount();}
	this.parent.createItem (this, newIndex);
	hookEvents ();
	register ();
	text = "";
}

public int getAlignment () {
	return 0;
}

public Table getParent () {
	return null;
}

public boolean getMoveable () {
	return false;
}

public boolean getResizable () {
	return false;
}

public String getToolTipText () {
	return "";
}

public int getWidth () {
	return _getWidth(); 
}

public void pack () {
}

public void removeControlListener (ControlListener listener) {
}

public void removeSelectionListener (SelectionListener listener) {
}

public void setAlignment (int alignment) {
}

public void setImage (Image image) {
}

public void setMoveable (boolean moveable) {
}

public void setResizable (boolean resizable) {
}

public void setText (String string) {
	_setText(string);
}

public void setToolTipText (String string) {
}

public void setWidth (int width) {
	_setWidth(width);
}

/*---------------- NATIVE INTERFACE ----------------*/

protected native void _createItem (Widget parent, int style, int index) /*-{
	if(!$wnd.dojo._hasResource["org.eclipse.swt.TableColumn"]){
		$wnd.dojo._hasResource["org.eclipse.swt.TableColumn"] = true;
		$wnd.dojo.provide("org.eclipse.swt.TableColumn");
		
		$wnd.dojo.declare("org.eclipse.swt.TableColumn", $wnd.dojox.grid.cell, {
			index: "",
			name: "&nbsp;",
			constructor: function(){
				this.grid = this.parent.layout.grid;
				this.subrow = 0;
				this.layoutIndex = this.index;
				this.fieldIndex = this.index;
				this.unitWidth = "6em";
				this.view = this.parent.views.views[0];
			},
			setText: function(string){
				this.parent.views.views[0].structure.rows[0][this.index].name = string;
				this.parent.views.render();
			},
		});
	}
	
	var jsParent = parent.@org.eclipse.swt.widgets.Widget::jsObject;
	var params = {};
	params.parent = jsParent;
	params.index = index;
	var self = new $wnd.org.eclipse.swt.TableColumn(params);
	try {
		this.@org.eclipse.swt.widgets.Widget::jsObject = self;
		var jsColumn = this.@org.eclipse.swt.widgets.TableColumn::jsColumn = {name:" ", width:"0px"};
		parent.@org.eclipse.swt.widgets.Table::jsColumns.splice(index, 0, jsColumn);
		parent.@org.eclipse.swt.widgets.Table::updateStructure()();
	} catch (e) {
//TODO Have to throw real exception for Java side also	
		$wnd.console.log(e);
	}	
}-*/;

//TODO implement
native int _getWidth () /*-{
//	var self = this.@org.eclipse.swt.widgets.Widget::jsObject;
//	width = $wnd.dojo.style(self.domNode,"width"); 
//	return width;
}-*/;

public native void _setText (String string) /*-{
	this.@org.eclipse.swt.widgets.TableColumn::jsColumn.name=string;
	var parent = this.@org.eclipse.swt.widgets.TableColumn::parent; 
	parent.@org.eclipse.swt.widgets.Table::updateStructure()();
}-*/;

public native void _setWidth (int width) /*-{
	this.@org.eclipse.swt.widgets.TableColumn::jsColumn.width=width+"px";
	var parent = this.@org.eclipse.swt.widgets.TableColumn::parent; 
	parent.@org.eclipse.swt.widgets.Table::updateStructure()();
}-*/;

}
